package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDEC;
import com.ejie.p06b.datatype.model.P06B49T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (26/01/2012)
 */
public class P06B49T00DAO {
	
	static private P06B49T00DAO instance = null;

	public static P06B49T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B49T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B49T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene un registro de la BD a partir de la clave primaria
    * @param numExp.
    *            parte de la clave primaria
    * @param ejer.
    *            parte de la clave primaria
    * @return un objeto P06B49T00Datatype o null si no se encuentra nada.
	* @throws Exception
    */
	public P06B49T00Datatype select(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B49T00DAO-select");
		P06B49T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B49T00Datatype();
	        	
	        	result.setEjercicio(lrst.getString(P06BTablas.P06B_P06B49_EJERCICIO));
	        	result.setNumExp(lrst.getString(P06BTablas.P06B_P06B49_NUMEXP));
			    result.setImpNetoAfecComis(lrst.getString(P06BTablas.P06B_P06B49_IMPNETO_AFEC_COMIS)==null?"":lrst.getString(P06BTablas.P06B_P06B49_IMPNETO_AFEC_COMIS));
			    result.setImpNetoAfecHonor(lrst.getString(P06BTablas.P06B_P06B49_IMPNETO_AFEC_HONOR)==null?"":lrst.getString(P06BTablas.P06B_P06B49_IMPNETO_AFEC_HONOR));
			    result.setImpNetoResto(lrst.getString(P06BTablas.P06B_P06B49_IMPNETO_RESTO)==null?"":lrst.getString(P06BTablas.P06B_P06B49_IMPNETO_RESTO));
			    result.setIngrOtrosAfec(lrst.getString(P06BTablas.P06B_P06B49_INGR_OTROS_AFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B49_INGR_OTROS_AFEC));
			    result.setIngrOtrosResto(lrst.getString(P06BTablas.P06B_P06B49_INGR_OTROS_RESTO)==null?"":lrst.getString(P06BTablas.P06B_P06B49_INGR_OTROS_RESTO));
			    result.setGastPerAfec(lrst.getString(P06BTablas.P06B_P06B49_GAST_PER_AFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B49_GAST_PER_AFEC));
			    result.setGastPerResto(lrst.getString(P06BTablas.P06B_P06B49_GAST_PER_RESTO)==null?"":lrst.getString(P06BTablas.P06B_P06B49_GAST_PER_RESTO));
			    result.setGastOtrosAfec(lrst.getString(P06BTablas.P06B_P06B49_GAST_OTROS_AFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B49_GAST_OTROS_AFEC));
			    result.setGastOtrosResto(lrst.getString(P06BTablas.P06B_P06B49_GAST_OTROS_RESTO)==null?"":lrst.getString(P06BTablas.P06B_P06B49_GAST_OTROS_RESTO));
			    result.setIngrFinancAfec(lrst.getString(P06BTablas.P06B_P06B49_INGR_FINANC_AFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B49_INGR_FINANC_AFEC));
			    result.setIngrFinancResto(lrst.getString(P06BTablas.P06B_P06B49_INGR_FINANC_RESTO)==null?"":lrst.getString(P06BTablas.P06B_P06B49_INGR_FINANC_RESTO));
			    result.setGastFinancAfec(lrst.getString(P06BTablas.P06B_P06B49_GAST_FINANC_AFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B49_GAST_FINANC_AFEC));
			    result.setGastFinancResto(lrst.getString(P06BTablas.P06B_P06B49_GAST_FINANC_RESTO)==null?"":lrst.getString(P06BTablas.P06B_P06B49_GAST_FINANC_RESTO));
	        }
	        P06BLog.send(2,this, "Fin P06B49T00DAO-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}
	
	/**
    * Obtiene los datos para el informe resumen de la DEC asociados al ejercicio indicado
    * @param ejerDEC.
    *            ejercicio de la DEC
    * @param objInformeDEC.
    *            objeto donde actualizar los datos obtenidos en la select
	* @throws Exception
    */
	public void selectDatContabMod31InformeDEC(String ejerDEC, P06BInformeDEC objInformeDEC) throws Exception{
		P06BLog.send(2,this, "Inicio P06B49T00DAO-selectDatContabMod31InformeDEC");
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_DATCONTABMOD31_INFORMEDEC;
        
        sql += " AND " + " (" + P06BTablas.P06B_P06B49_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA+"-%' or " + P06BTablas.P06B_P06B49_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA+"-%' or " + P06BTablas.P06B_P06B49_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_JURIDICA+"-%' or " + P06BTablas.P06B_P06B49_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_FISICA+"-%')";
    	
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejerDEC.toUpperCase());
        	lrst = lstm.executeQuery();
        	
	        if (lrst.next()) {
        		objInformeDEC.setIngAfecMod31CorrM3(lrst.getDouble("ING_AFEC_MOD31"));
        		objInformeDEC.setOtrosIngMod31CorrM3(lrst.getDouble("OTROS_ING_MOD31"));
        		objInformeDEC.setIngFinanMod31CorrM3(lrst.getDouble("ING_FINAN_MOD31"));
        		objInformeDEC.setIngRestoMod31CorrM3(lrst.getDouble("ING_RESTO_MOD31"));
        		objInformeDEC.setGastPerMod31CorrM3(lrst.getDouble("GAST_PER_MOD31"));
        		objInformeDEC.setOtrosGastMod31CorrM3(lrst.getDouble("OTROS_GAST_MOD31"));
        		objInformeDEC.setGastFinanMod31CorrM3(lrst.getDouble("GAST_FINAN_MOD31"));
        		objInformeDEC.setGastRestoMod31CorrM3(lrst.getDouble("GAST_RESTO_MOD31"));
	        }
	        P06BLog.send(2,this, "Fin P06B49T00DAO-selectDatContabMod31InformeDEC");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
	}
	
	
	/**
	    * Obtiene los datos para el informe resumen de la DEC asociados al ejercicio indicado
	    * @param ejerDEC.
	    *            ejercicio de la DEC
	    * @param objInformeOtroDEC.
	    *            objeto donde actualizar los datos obtenidos en la select
		* @throws Exception
	    */
		public void selectDatosInformeOtroDEC(String ejerDEC, P06BInformeOtroDEC objInformeOtroDEC) throws Exception{
			P06BLog.send(2,this, "Inicio P06B49T00DAO-selectDatosInformeOtroDEC");
			PreparedStatement lstm  = null;
	        ResultSet lrst  = null;
	        String sql = SELECT_DATOS_INFORMEOTRODEC;
	        String sTipoMediador;
	        
	        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
	        try {
	        	lstm = lconConexion.prepareStatement(sql);
	        	lstm.setString(1,ejerDEC.toUpperCase());
	        	lrst = lstm.executeQuery();
	        	
		        while (lrst.next()) {

	        		sTipoMediador = lrst.getString("TC");
		        	if(sTipoMediador.equals(P06BConstantes.P06B_CORREDORES_CTEEXP_FISICA)){
		        		objInformeOtroDEC.setD49_F1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD49_F2(lrst.getDouble("D2"));
		        	}else if(sTipoMediador.equals(P06BConstantes.P06B_CORREDORES_CTEEXP_JURIDICA)){
		        		objInformeOtroDEC.setD49_J1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD49_J2(lrst.getDouble("D2"));
		        	}else if(sTipoMediador.equals(P06BConstantes.P06B_AGENTEVINCULADO_CTEEXP_FISICA)){
		        		objInformeOtroDEC.setD49_AF1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD49_AF2(lrst.getDouble("D2"));
		        	}else if(sTipoMediador.equals(P06BConstantes.P06B_AGENTEVINCULADO_CTEEXP_JURIDICA)){
		        		objInformeOtroDEC.setD49_AJ1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD49_AJ2(lrst.getDouble("D2"));
		        	}
		        }
		        P06BLog.send(2,this, "Fin P06B49T00DAO-selectDatosInformeOtroDEC");
		    } catch (SQLException e) {
		    	P06BLog.send(2,this, "error: " +e.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e;
		    }catch (Exception e2) {	 
	        	P06BLog.send(2,this, "error: " +e2.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e2;
		    }finally {
		    	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		    }
		}
			
		
	private static String SELECT_BY_PK =
		"SELECT " +	
		P06BTablas.P06B_P06B49_EJERCICIO + ", " + 
		P06BTablas.P06B_P06B49_NUMEXP + ", " + 
		P06BTablas.P06B_P06B49_IMPNETO_AFEC_COMIS + ", " + 
		P06BTablas.P06B_P06B49_IMPNETO_AFEC_HONOR + ", " + 
		P06BTablas.P06B_P06B49_IMPNETO_RESTO + ", " + 
		P06BTablas.P06B_P06B49_INGR_OTROS_AFEC + ", " + 
		P06BTablas.P06B_P06B49_INGR_OTROS_RESTO + ", " + 
		P06BTablas.P06B_P06B49_GAST_PER_AFEC + ", " +
		P06BTablas.P06B_P06B49_GAST_PER_RESTO + ", " + 
		P06BTablas.P06B_P06B49_GAST_OTROS_AFEC + ", " + 
		P06BTablas.P06B_P06B49_GAST_OTROS_RESTO + ", " + 
		P06BTablas.P06B_P06B49_INGR_FINANC_AFEC + ", " + 
		P06BTablas.P06B_P06B49_INGR_FINANC_RESTO + ", " + 
		P06BTablas.P06B_P06B49_GAST_FINANC_AFEC + ", " + 
		P06BTablas.P06B_P06B49_GAST_FINANC_RESTO +
		
		" FROM "+ P06BTablas.P06B_P06B49T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B49_EJERCICIO + " = ? and " + P06BTablas.P06B_P06B49_NUMEXP + " = ?";

	private static String SELECT_DATCONTABMOD31_INFORMEDEC =
		"SELECT (sum(nvl("+P06BTablas.P06B_P06B49_IMPNETO_AFEC_COMIS+",0)) + sum(nvl("+P06BTablas.P06B_P06B49_IMPNETO_AFEC_HONOR+",0))) as ING_AFEC_MOD31,"+
		" sum(nvl("+P06BTablas.P06B_P06B49_INGR_OTROS_AFEC+",0)) as OTROS_ING_MOD31,"+
		" sum(nvl("+P06BTablas.P06B_P06B49_INGR_FINANC_AFEC+",0)) as ING_FINAN_MOD31,"+
		" (sum(nvl("+P06BTablas.P06B_P06B49_IMPNETO_RESTO+",0)) + sum(nvl("+P06BTablas.P06B_P06B49_INGR_OTROS_RESTO+",0)) + sum(nvl("+P06BTablas.P06B_P06B49_INGR_FINANC_RESTO+",0))) as ING_RESTO_MOD31,"+
		" sum(nvl("+P06BTablas.P06B_P06B49_GAST_PER_AFEC+",0)) as GAST_PER_MOD31,"+
		" sum(nvl("+P06BTablas.P06B_P06B49_GAST_OTROS_AFEC+",0)) as OTROS_GAST_MOD31,"+
		" (sum(nvl("+P06BTablas.P06B_P06B49_GAST_FINANC_AFEC+",0)) + sum(nvl("+P06BTablas.P06B_P06B49_GAST_FINANC_RESTO+",0))) as GAST_FINAN_MOD31,"+
		" (sum(nvl("+P06BTablas.P06B_P06B49_GAST_PER_RESTO+",0)) + sum(nvl("+P06BTablas.P06B_P06B49_GAST_OTROS_RESTO+",0))) as GAST_RESTO_MOD31"+
		" FROM "+ P06BTablas.P06B_P06B49T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B49_EJERCICIO + " = ?";
	
	private static String SELECT_DATOS_INFORMEOTRODEC =
		"SELECT SUBSTR(" + P06BTablas.P06B_P06B49_NUMEXP + ", 0, INSTR(" + P06BTablas.P06B_P06B49_NUMEXP + ", '-')-1) as TC, SUM(NVL(" +
		P06BTablas.P06B_P06B49_IMPNETO_AFEC_COMIS + ",0)) as D1, SUM(NVL(" +
		P06BTablas.P06B_P06B49_IMPNETO_AFEC_HONOR + ",0)) as D2 FROM " +
		P06BTablas.P06B_P06B49T00_TABLA + " WHERE " + P06BTablas.P06B_P06B49_EJERCICIO + " = ? GROUP BY SUBSTR(" + P06BTablas.P06B_P06B49_NUMEXP + ", 0, INSTR(" + P06BTablas.P06B_P06B49_NUMEXP + ", '-')-1)" +
		" ORDER BY SUBSTR(" + P06BTablas.P06B_P06B49_NUMEXP + ", 0, INSTR(" + P06BTablas.P06B_P06B49_NUMEXP + ", '-')-1)";

}
